"use client"

import { NavigationLink } from "@/components/layout/navigation.link";
import { Text } from "@/components/typeography/text";
import { Button } from "@/components/ui/button";
import { useRouter } from "@/lib/navigation.router";
import { signOut } from "aws-amplify/auth";

export default function Unauthorized() {
  const router = useRouter()

  return (
    <div className="relative w-full min-h-svh overflow-hidden rounded-lg bg-background shadow-sm border-border">
      <div
        className="sticky w-full flex flex-col gap-3 justify-center items-center mt-32"
      >
        <Text variant={"h1"}>Unauthorized</Text>
        <Text variant={"p"} affects={"lead"}>You account is unauthorized to access this content. Contact your systems administrator for access or:</Text>

        <div className="mt-3 grid grid-cols-1 md:grid-cols-2 gap-3">
          <NavigationLink
            href="https://preview.mitripplanner.org"
            className="transition-all hover:underline grid place-items-center"
          >
            Go to preview site.
          </NavigationLink>

          <Button
            variant={"secondary"}
            onClick={async () => {
              await signOut();
              router.navigateAndReplaceHistory('/login')
            }}
          >
            Login with another account
          </Button>
        </div>
      </div>
    </div>
  );
}



